<?php
namespace Aelia\WC\CurrencySwitcher\ShippingPricing\Integrations\BolderElements;
if(!defined('ABSPATH')) { exit; } // Exit if accessed directly

use Aelia\WC\CurrencySwitcher\ShippingPricing\Definitions;
use Aelia\WC\CurrencySwitcher\ShippingPricing\WC_Aelia_CS_ShippingPricing_Plugin;
use \WC_Aelia_CurrencySwitcher;

/**
 * Implements an integration with the BoldeElements Table Rates Shipping plugin.
 * This is meant as a temporary solution to allow administrators to enter shipping
 * costs in each currency when using that shipping plugin.
 *
 * @since 1.5.0.230210
 */
class BE_Table_Rates_Integration {
	/**
	 * Constructor.
	 */
	public function __construct()	{
		$this->set_hooks();
	}

	/**
	 * Sets the hooks used by this integration.
	 *
	 * @return void
	 */
	protected function set_hooks(): void {
		add_filter('wc_aelia_cs_shipping_method_overrides', [$this, 'wc_aelia_cs_shipping_method_overrides']);

		// Filters for the the BE Table Rates Settings page (e.g. to show the correct currency symbol)
		add_filter('betrs_processed_table_rates_settings', [$this, 'betrs_processed_table_rates_settings'], 50, 1);
		add_filter('betrs_shipping_cost_options', [$this, 'betrs_shipping_cost_options'], 50, 1);
		add_filter('betrs_shipping_cost_units_every', [$this, 'betrs_shipping_cost_units_every'], 50, 1);
	}

	/**
	 * This method is used as a filter for hook "aelia_cs_shippingpricing_managing_shipping_method_settings"
	 * when the settings page of the BE Table Rates plugin is rendered. It always returns true, so that
	 * the Shipping Pricing Addon can fetch the shipping settings currency a the active currency when
	 * the BE Table Rates fetches information such as the currency symbol.
	 *
	 * @return string
	 */
	public function get_shipping_settings_currency(): string {
		$base_currency = (string)WC_Aelia_CS_ShippingPricing_Plugin::instance()->base_currency();

		// Fetch the shipping settings currency from the following location, in order:
		// - URL
		// - Cookies
		// - Shop's base currency
		$shipping_settings_currency = $_GET[Definitions::ARG_SHIPPING_PRICING_CURRENCY] ?? $_COOKIE[Definitions::SESSION_SHIPPING_PRICING_SETTINGS_CURRENCY] ?? $base_currency;

		if(empty($shipping_settings_currency) || !WC_Aelia_CurrencySwitcher::instance()->is_valid_currency($shipping_settings_currency)) {
			$shipping_settings_currency = $base_currency;
		}
		return (string)$shipping_settings_currency;
	}

	/**
	 * Intercepts the list of shippign class overrides, to add the custom class that extends
	 * the default BE Table Rates class.
	 *
	 * @param array $overrides_class_map
	 * @return array
	 */
	public function wc_aelia_cs_shipping_method_overrides(array $overrides_class_map): array {
		$overrides_class_map['BE_Table_Rate_Method'] = 'Aelia_CS_BE_Table_Rate_Method';
		return $overrides_class_map;
	}

	/**
	 * Saves the extra information to keep track of currency-specific settings.
	 *
	 * @param array $settings
	 * @return array
	 */
	public function betrs_processed_table_rates_settings($settings): array {
		foreach($settings as $key => $data) {
			$data[Definitions::FIELD_MANUAL_PRICES_ENABLED] = isset($_POST['woocommerce_betrs_shipping_currency_manual_prices_enabled']) ? $_POST['woocommerce_betrs_shipping_currency_manual_prices_enabled'] : 0;
			$settings[$key] = $data;
		}
		return $settings;
	}

	/**
	 * Alters the options displayed by the BE Table Rates Shipping plugin, to show the correct currency.
	 *
	 * @param array $options
	 * @return array
	 */
	public function betrs_shipping_cost_options($options): array {
		$options[''] = get_woocommerce_currency_symbol($this->get_shipping_settings_currency());

		return $options;
	}

	/**
	 * Alters the options displayed by the BE Table Rates Shipping plugin, to show the correct currency.
	 *
	 * @param array $options
	 * @return array
	 * @since 1.4.0.200225
	 */
	public function betrs_shipping_cost_units_every($options): array {
		$options['subtotal'] = get_woocommerce_currency_symbol($this->get_shipping_settings_currency());

		return $options;
	}
}