<?php
if(!defined('ABSPATH')) { exit; } // Exit if accessed directly

require_once('aelia-wc-requirementscheck.php');

/**
 * Checks that plugin's requirements are met.
 */
class Aelia_WC_ShippingPricing_RequirementsChecks extends Aelia_WC_RequirementsChecks {
	// @var string The namespace for the messages displayed by the class.
	protected $text_domain = 'wc-aelia-cs-shippingpricing';
	// @var string The plugin for which the requirements are being checked. Change it in descendant classes.
	protected $plugin_name = 'Aelia Shipping Pricing for Currency Switcher';

	/**
	 * The minimum version of PHP required by the plugin.
	 *
	 * @var string
	 * @since 1.4.0.200225
	 */
	protected $required_php_version = '7.1';

	// @var array An array of WordPress plugins (name => version) required by the plugin.
	protected $required_plugins = array(
		'WooCommerce' => '3.0',
		'Aelia Foundation Classes for WooCommerce' => array(
			'version' => '2.1.8.210518',
			'extra_info' => 'You can <a href="https://bit.ly/WC_AFC_S3">get the plugin from our site</a>, free of charge.',
			'autoload' => true,
			'url' => 'https://bit.ly/WC_AFC_S3',
		),
		'Aelia Currency Switcher for WooCommerce' => array(
			'version' => '4.7.0.190307',
			'extra_info' => 'You can buy the plugin <a href="https://aelia.co/shop/currency-switcher-woocommerce/">from our shop</a>. If you already bought the plugin, please make sure that you download the latest version, using the link you received with your order.',
		),
	);

	/**
	 * Factory method. It MUST be copied to every descendant class, as it has to
	 * be compatible with PHP 5.2 and earlier, so that the class can be instantiated
	 * in any case and and gracefully tell the user if PHP version is insufficient.
	 *
	 * @return Aelia_WC_AFC_RequirementsChecks
	 */
	public static function factory() {
		return new static();
	}
}
