<?php
/**
 * Create notification object and get message and message type as WooCommerce is inactive
 * also set variable allowed on 0 to disable submit button on step 1 of configuration
 */
$notifications_obj = new WooSEA_Elite_Get_Admin_Notifications;
if (!in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
        $notifications_box = $notifications_obj->get_admin_notifications ( "9", "false" );
} else {
        $notifications_box = $notifications_obj->get_admin_notifications ( '10', 'false' );
}

if (array_key_exists('project_hash', $_GET)){
	$project = WooSEA_Elite_Update_Project::get_project_data(sanitize_text_field($_GET['project_hash']));	
	$project_hash = $_GET['project_hash'];
	$step = $_GET['step'];
	if(isset($project['history_products'])){
		$project_history = $project['history_products'];
	} else {
		$project_history = array();
	}

	// Only show last 30 updates
	$project_history = array_slice($project_history,-30,30,true);   
	
	$projectname = ucfirst($project['projectname']);
	$plotData = "";
	foreach($project_history as $key => $value){
		$plotData  .= "[\"$key\", $value], ";
	}
}
$plotData = trim($plotData, ",");
?>
<div class="wrap">
        <div class="woo-product-feed-pro-form-style-2">
   	<table class="woo-product-feed-pro-table"> 
 		<tbody class="woo-product-feed-pro-body">
                        <div class="woo-product-feed-pro-form-style-2-heading"><?php _e( 'Feed statistics','woo-product-feed-pro' );?></div>

                        <div class="<?php _e($notifications_box['message_type']); ?>">
                                <p><?php _e($notifications_box['message'], 'sample-text-domain' ); ?></p>
                        </div>
	
			<tr>
				<td align="center">
					<input type="hidden" id="project_hash" name="project_hash" value="<?php print "$project_hash";?>">
					<input type="hidden" id="step" name="step" value="<?php print "$step";?>">

					<div id="content">

						<div class="chart-container">
							<div id="placeholder" class="chart-placeholder main" style="width:auto;height:400px;"></div>
						</div>	
					
						<script type="text/javascript">
						jQuery(function() {
							var data = [ <?php echo $plotData; ?> ];
		
							jQuery.plot("#placeholder", [ data ], {
								series: {
									label: "Number of products in feed",
									color: "#3498db",
									bars: {
										show: true,
										fill: true,
										hoverable: true,
										lineWidth: 0,
										barWidth: 0.8,
										align: "center",
										fillColor: "#3498db",
									}
								},
							
								xaxis: {
									mode: "categories",
									color: "#aaa",
									position: "bottom",
									tickColor: "transparant",
									tickLength: 1,
									font: {
										color: "#aaa"
									}
								},

								yaxis: {
									min: 0,
									minTickSize: 1,
									tickDecimals: 0,
									color: "#d4d9dc",
									font: { color: "#aaa" }
								},

								grid: {
									color: '#aaa',
									borderColor: 'transparent',
									borderWidth: 0,
									hoverable: true		
								},

							});

							// Add the Flot version string to the footer
							jQuery("#footer").prepend("Flot " + jQuery.plot.version + " &ndash; ");
						});
						</script>
					</div>
				</td>
			</tr>
		</tbody>
	</table>
	</div>
</div>
